/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.encoder;

public class JsonEscapeUtil {
    protected static final char[] HEXADECIMALS_TABLE = "0123456789ABCDEF".toCharArray();
    static final int ESCAPE_CODES_COUNT = 32;
    static final String[] ESCAPE_CODES = new String[32];

    private static String _computeEscapeCodeBelowASCII32(char c2) {
        if (c2 > ' ') {
            throw new IllegalArgumentException("input must be less than 32");
        }
        StringBuilder sb = new StringBuilder(6);
        sb.append("\\u00");
        int highPart = c2 >> 4;
        sb.append(HEXADECIMALS_TABLE[highPart]);
        int lowPart = c2 & 0xF;
        sb.append(HEXADECIMALS_TABLE[lowPart]);
        return sb.toString();
    }

    static String getObligatoryEscapeCode(char c2) {
        if (c2 < ' ') {
            return ESCAPE_CODES[c2];
        }
        if (c2 == '\"') {
            return "\\\"";
        }
        if (c2 == '/') {
            return "\\/";
        }
        if (c2 == '\\') {
            return "\\\\";
        }
        return null;
    }

    public static String jsonEscapeString(String input) {
        int length = input.length();
        int lenthWithLeeway = (int)((double)length * 1.1);
        StringBuilder sb = new StringBuilder(lenthWithLeeway);
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = input.charAt(i2);
            String escaped = JsonEscapeUtil.getObligatoryEscapeCode(c2);
            if (escaped == null) {
                sb.append(c2);
                continue;
            }
            sb.append(escaped);
        }
        return sb.toString();
    }

    static {
        block7: for (char c2 = '\u0000'; c2 < ' '; c2 = (char)(c2 + '\u0001')) {
            switch (c2) {
                case '\b': {
                    JsonEscapeUtil.ESCAPE_CODES[c2] = "\\b";
                    continue block7;
                }
                case '\t': {
                    JsonEscapeUtil.ESCAPE_CODES[c2] = "\\t";
                    continue block7;
                }
                case '\n': {
                    JsonEscapeUtil.ESCAPE_CODES[c2] = "\\n";
                    continue block7;
                }
                case '\f': {
                    JsonEscapeUtil.ESCAPE_CODES[c2] = "\\f";
                    continue block7;
                }
                case '\r': {
                    JsonEscapeUtil.ESCAPE_CODES[c2] = "\\r";
                    continue block7;
                }
                default: {
                    JsonEscapeUtil.ESCAPE_CODES[c2] = JsonEscapeUtil._computeEscapeCodeBelowASCII32(c2);
                }
            }
        }
    }
}

