/*
 * Decompiled with CFR 0.152.
 */
package iaik.pkcs.pkcs7;

import iaik.asn1.ASN1Object;
import iaik.asn1.ASN1Type;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.SEQUENCE;
import iaik.asn1.structures.AlgorithmID;
import iaik.pkcs.PKCSException;
import iaik.pkcs.pkcs7.IssuerAndSerialNumber;
import iaik.security.cipher.SecretKey;
import iaik.utils.Util;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;

public class RecipientInfo
implements ASN1Type {
    byte[] e;
    PublicKey b;
    AlgorithmID c;
    IssuerAndSerialNumber d;
    int a;

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Version: " + this.a + "\n");
        stringBuffer.append(this.d);
        stringBuffer.append("keyEncryptionAlgorithm: " + this.c + "\n");
        stringBuffer.append("encryptedKey: " + (this.e == null ? "not set" : Util.toString(this.e, 0, 5)) + "...");
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        if (this.d == null) {
            throw new NullPointerException("issuerAndSerialNumber field of this RecipientInfo not set!");
        }
        if (this.c == null) {
            throw new NullPointerException("keyEncryptionAlgorithm field of this RecipientInfo not set!");
        }
        if (this.e == null) {
            throw new NullPointerException("encryptedKey field of this RecipientInfo not set!");
        }
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addComponent(new INTEGER(this.a));
        sEQUENCE.addComponent(this.d.toASN1Object());
        sEQUENCE.addComponent(this.c.toASN1Object());
        sEQUENCE.addComponent(new OCTET_STRING(this.e));
        return sEQUENCE;
    }

    public int getVersion() {
        return this.a;
    }

    public AlgorithmID getKeyEncryptionAlgorithm() {
        return this.c;
    }

    public IssuerAndSerialNumber getIssuerAndSerialNumber() {
        return this.d;
    }

    public byte[] getEncryptedKey() {
        return this.e;
    }

    public void encryptKey(javax.crypto.SecretKey secretKey) throws PKCSException {
        if (this.c == null) {
            throw new PKCSException("Unable to encrypt symmetric key. Content-encryption algorithm is not set!");
        }
        if (this.b == null) {
            throw new PKCSException("Unable to encrypt symmetric key. Public key is not set!");
        }
        if (this.c.equals(AlgorithmID.rsaEncryption)) {
            try {
                Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
                cipher.init(1, this.b);
                this.e = cipher.doFinal(secretKey.getEncoded());
                return;
            }
            catch (Exception exception) {
                throw new PKCSException("Unable to encrypt the symmetric key.");
            }
        }
    }

    public javax.crypto.SecretKey decryptKey(PrivateKey privateKey) throws InvalidKeyException, PKCSException {
        byte[] byArray = null;
        try {
            if (!this.c.equals(AlgorithmID.rsa) && !this.c.equals(AlgorithmID.rsaEncryption)) {
                throw new PKCSException("Unknown key encryption algorithm: " + this.c.getName());
            }
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, privateKey);
            byArray = cipher.doFinal(this.e);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("No implementation for \"RSA/ECB/PKCS1Padding\"");
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new PKCSException(generalSecurityException.toString());
        }
        return new SecretKey(byArray, "RAW");
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.a = ((BigInteger)aSN1Object.getComponentAt(0).getValue()).intValue();
        this.d = new IssuerAndSerialNumber(aSN1Object.getComponentAt(1));
        this.c = new AlgorithmID(aSN1Object.getComponentAt(2));
        this.e = (byte[])aSN1Object.getComponentAt(3).getValue();
    }

    public RecipientInfo(X509Certificate x509Certificate, AlgorithmID algorithmID) throws NoSuchAlgorithmException {
        this.b = x509Certificate.getPublicKey();
        this.d = new IssuerAndSerialNumber(x509Certificate);
        this.c = algorithmID;
        if (!this.c.equals(AlgorithmID.rsaEncryption)) {
            throw new NoSuchAlgorithmException("Unknown key encryption algorithm: " + this.c.getName());
        }
    }

    public RecipientInfo(IssuerAndSerialNumber issuerAndSerialNumber, AlgorithmID algorithmID, byte[] byArray) {
        this.d = issuerAndSerialNumber;
        this.c = algorithmID;
        this.e = byArray;
    }

    public RecipientInfo(ASN1Object aSN1Object) throws CodingException {
        this.decode(aSN1Object);
    }

    public RecipientInfo() {
    }
}

