/*
 * Decompiled with CFR 0.152.
 */
package iaik.x509.extensions.qualified.structures.etsi;

import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.INTEGER;
import iaik.asn1.ObjectID;
import iaik.asn1.PrintableString;
import iaik.asn1.SEQUENCE;
import iaik.x509.extensions.qualified.structures.QCStatementInfo;
import java.math.BigInteger;

public class QcEuLimitValue
extends QCStatementInfo {
    int a;
    int c;
    Object b;
    public static final ObjectID statementID = new ObjectID("0.4.0.1862.1.2", "QcEuLimitValue");

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Currency: " + this.b + "\n");
        stringBuffer.append("Amount: " + this.c + "\n");
        stringBuffer.append("Exponent: " + this.a + "\n");
        return stringBuffer.toString();
    }

    public ASN1Object toASN1Object() {
        SEQUENCE sEQUENCE = new SEQUENCE();
        if (this.b instanceof BigInteger) {
            sEQUENCE.addComponent(new INTEGER((BigInteger)this.b));
        } else {
            sEQUENCE.addComponent(new PrintableString((String)this.b));
        }
        sEQUENCE.addComponent(new INTEGER(this.c));
        sEQUENCE.addComponent(new INTEGER(this.a));
        return sEQUENCE;
    }

    public BigInteger getValue() {
        return BigInteger.valueOf(this.c).multiply(BigInteger.valueOf(10L).pow(this.a));
    }

    public ObjectID getStatementID() {
        return statementID;
    }

    public int getExponent() {
        return this.a;
    }

    public Object getCurrency() {
        return this.b;
    }

    public int getAmount() {
        return this.c;
    }

    public void decode(ASN1Object aSN1Object) throws CodingException {
        this.b = aSN1Object.getComponentAt(0).getValue();
        this.c = ((BigInteger)aSN1Object.getComponentAt(1).getValue()).intValue();
        this.a = ((BigInteger)aSN1Object.getComponentAt(2).getValue()).intValue();
    }

    public QcEuLimitValue(String string, int n2, int n3) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Cannot create QcEuLimitValue. Missing currency specification.");
        }
        if (string.length() != 3) {
            throw new IllegalArgumentException("Invalid ISO 4217 currency code");
        }
        this.b = string;
        this.c = n2;
        this.a = n3;
    }

    public QcEuLimitValue(int n2, int n3, int n4) throws IllegalArgumentException {
        if (n2 < 1 || n2 > 999) {
            throw new IllegalArgumentException("Invalid ISO 4217 curreny code. Must be between 1 .. 999.");
        }
        this.b = BigInteger.valueOf(n2);
        this.c = n3;
        this.a = n4;
    }

    public QcEuLimitValue() {
    }
}

