/*
 * Decompiled with CFR 0.152.
 */
package keySuite.panel;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.ParseException;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.MaskFormatter;
import keySuite.Main;
import keySuite.frame.MainFrame;

public class LoginPanel
extends JPanel {
    private JLabel AppIDLabel;
    private JFormattedTextField appIDFormattedTextField;
    private JButton loginButton;
    private JLabel logoLabel;
    private JLabel sample1Label;
    private JLabel sample2Label;

    public LoginPanel() {
        this.initComponents();
        this.logoLabel.setText(null);
        this.logoLabel.setIcon(new ImageIcon("./res/images/keySuite.png"));
    }

    private void initComponents() {
        this.AppIDLabel = new JLabel();
        this.appIDFormattedTextField = new JFormattedTextField();
        this.loginButton = new JButton();
        this.sample1Label = new JLabel();
        this.sample2Label = new JLabel();
        this.logoLabel = new JLabel();
        this.AppIDLabel.setFont(new Font("Tahoma", 0, 18));
        this.AppIDLabel.setHorizontalAlignment(0);
        this.AppIDLabel.setText("\u0e2b\u0e21\u0e32\u0e22\u0e40\u0e25\u0e02\u0e43\u0e1a\u0e04\u0e33\u0e02\u0e2d (Application ID)");
        try {
            this.appIDFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new MaskFormatter("UUU-##-####-#-#-##-#######")));
        }
        catch (ParseException ex) {
            ex.printStackTrace();
        }
        this.appIDFormattedTextField.setHorizontalAlignment(0);
        this.appIDFormattedTextField.setFont(new Font("Tahoma", 0, 18));
        this.appIDFormattedTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                LoginPanel.this.appIDFormattedTextFieldKeyPressed(evt);
            }
        });
        this.loginButton.setFont(new Font("Tahoma", 0, 20));
        this.loginButton.setText("Login");
        this.loginButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginPanel.this.loginButtonActionPerformed(evt);
            }
        });
        this.sample1Label.setFont(new Font("Tahoma", 0, 12));
        this.sample1Label.setForeground(new Color(0, 153, 0));
        this.sample1Label.setHorizontalAlignment(0);
        this.sample1Label.setText("Example : NEW-XX-XXXX-X-X-XX-XXXXXXX");
        this.sample2Label.setFont(new Font("Tahoma", 0, 12));
        this.sample2Label.setForeground(new Color(0, 153, 0));
        this.sample2Label.setHorizontalAlignment(0);
        this.sample2Label.setText("Example : REN-XX-XXXX-X-X-XX-XXXXXXX");
        this.logoLabel.setFont(new Font("Tahoma", 0, 36));
        this.logoLabel.setHorizontalAlignment(0);
        this.logoLabel.setText("TDID KeySuite V.2");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.logoLabel, -1, 422, Short.MAX_VALUE).addComponent(this.AppIDLabel, -1, -1, Short.MAX_VALUE).addComponent(this.appIDFormattedTextField, -2, 270, -2).addComponent(this.sample1Label, -1, -1, Short.MAX_VALUE).addComponent(this.sample2Label, -1, -1, Short.MAX_VALUE).addComponent(this.loginButton, -2, 150, -2)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(43, 43, 43).addComponent(this.logoLabel).addGap(32, 32, 32).addComponent(this.AppIDLabel, -2, 22, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.appIDFormattedTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.sample1Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sample2Label).addGap(27, 27, 27).addComponent(this.loginButton, -2, 44, -2).addContainerGap(47, Short.MAX_VALUE)));
    }

    private void loginButtonActionPerformed(ActionEvent evt) {
        try {
            try {
                Main.applicationType = this.getApplicationType();
                Main.keyStoreType = this.getKeyStoreType();
                Main.appIDRunningNumber = this.getAppIDRunningNumber();
                Main.CAID = this.getCAId();
                if (Main.applicationType.equalsIgnoreCase("NEW") && this.appIDFormattedTextField.getValue().toString().length() == 26) {
                    if (Main.keyStoreType.equals("1")) {
                        MainFrame.newCertPanel.setBackLabelVisible(false);
                        Main.mf.switchCardLayout("newCertPanelCard");
                    } else if (Main.keyStoreType.equals("2")) {
                        MainFrame.newCertPanel.setBackLabelVisible(false);
                        Main.mf.switchCardLayout("newCertPanelCard");
                    } else if (Main.keyStoreType.equals("3")) {
                        Main.mf.switchCardLayout("selectKeyStoreTypeCard");
                    } else if (Main.keyStoreType.equals("4")) {
                        JOptionPane.showMessageDialog(null, "\u0e43\u0e1a\u0e23\u0e31\u0e1a\u0e23\u0e2d\u0e07\u0e2f \u0e1b\u0e23\u0e30\u0e40\u0e20\u0e17 SSL Certificate \u0e44\u0e21\u0e48\u0e2a\u0e32\u0e21\u0e32\u0e23\u0e16\u0e43\u0e0a\u0e49 TDID KeySuit \u0e44\u0e14\u0e49\n\u0e01\u0e23\u0e38\u0e13\u0e32\u0e2a\u0e23\u0e49\u0e32\u0e07\u0e04\u0e39\u0e48\u0e01\u0e38\u0e0d\u0e41\u0e08\u0e2a\u0e48\u0e27\u0e19\u0e15\u0e31\u0e27\u0e41\u0e25\u0e30\u0e44\u0e1f\u0e25\u0e4c CSR \u0e14\u0e49\u0e27\u0e22\u0e40\u0e04\u0e23\u0e37\u0e48\u0e2d\u0e07\u0e21\u0e37\u0e2d(Tools) \u0e02\u0e2d\u0e07\u0e17\u0e48\u0e32\u0e19\u0e40\u0e2d\u0e07", "\u0e02\u0e49\u0e2d\u0e1c\u0e34\u0e14\u0e1e\u0e25\u0e32\u0e14", 0);
                    }
                    MainFrame.newCertPanel.setButtonLabel();
                    Main.applicationID = this.appIDFormattedTextField.getText().replaceAll("-", "");
                    Main.mf.logoutMenuItem.setEnabled(true);
                } else if (!Main.applicationType.equalsIgnoreCase("REN") || this.appIDFormattedTextField.getValue().toString().length() != 26) {
                    JOptionPane.showMessageDialog(null, "Application ID \u0e44\u0e21\u0e48\u0e16\u0e39\u0e01\u0e15\u0e49\u0e2d\u0e07", "Error", 0);
                }
            }
            catch (BadLocationException e2) {
                JOptionPane.showMessageDialog(null, "Application ID \u0e44\u0e21\u0e48\u0e16\u0e39\u0e01\u0e15\u0e49\u0e2d\u0e07", "Error", 0);
                this.clear();
            }
            catch (NullPointerException e3) {
                JOptionPane.showMessageDialog(null, "Application ID \u0e44\u0e21\u0e48\u0e16\u0e39\u0e01\u0e15\u0e49\u0e2d\u0e07", "Error", 0);
                this.clear();
            }
        }
        finally {
            this.clear();
        }
    }

    private String getApplicationType() throws BadLocationException {
        return this.appIDFormattedTextField.getValue().toString().substring(0, 3);
    }

    private String getKeyStoreType() {
        String[] splitText = this.appIDFormattedTextField.getValue().toString().split("\\-");
        return splitText[3];
    }

    private String getAppIDRunningNumber() {
        String[] splitText = this.appIDFormattedTextField.getValue().toString().split("\\-");
        return splitText[6];
    }

    private String getCAId() {
        String[] splitText = this.appIDFormattedTextField.getValue().toString().split("\\-");
        return splitText[1];
    }

    private void appIDFormattedTextFieldKeyPressed(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 10) {
            this.appIDFormattedTextField.setValue(this.appIDFormattedTextField.getText().replaceAll(" ", ""));
            this.loginButtonActionPerformed(null);
        }
    }

    private void clear() {
        this.appIDFormattedTextField.setValue(null);
    }
}

