/*
 * Decompiled with CFR 0.152.
 */
package keySuite.pkcs10;

import iaik.asn1.CodingException;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.asn1.structures.Name;
import iaik.pkcs.PKCSException;
import iaik.pkcs.pkcs10.CertificateRequest;
import iaik.pkcs.pkcs11.TokenException;
import iaik.pkcs.pkcs11.objects.RSAPrivateKey;
import iaik.pkcs.pkcs11.objects.RSAPublicKey;
import iaik.pkcs.pkcs9.ExtensionRequest;
import iaik.utils.Base64OutputStream;
import iaik.x509.X509ExtensionException;
import iaik.x509.extensions.KeyUsage;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Base64;
import java.util.Random;
import keySuite.token.Token;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;

public class CSRGenerator {
    public CertificateRequest genCSRFile(Name subject, iaik.pkcs.pkcs11.objects.KeyPair RSAKeyPair, Token token) throws InvalidKeyException, IOException, CodingException, X509ExtensionException, NoSuchAlgorithmException, InvalidKeySpecException, TokenException, PKCSException, SignatureException {
        RSAPublicKey PublicKey2 = (RSAPublicKey)RSAKeyPair.getPublicKey();
        RSAPrivateKey PrivateKey2 = (RSAPrivateKey)RSAKeyPair.getPrivateKey();
        BigInteger Modulus = new BigInteger(1, PublicKey2.getModulus().getByteArrayValue());
        BigInteger Exponent = new BigInteger(1, PublicKey2.getPublicExponent().getByteArrayValue());
        RSAPublicKeySpec PublicKeySpec = new RSAPublicKeySpec(Modulus, Exponent);
        KeyFactory kf = KeyFactory.getInstance("RSA");
        CertificateRequest CSR = new CertificateRequest(kf.generatePublic(PublicKeySpec), subject);
        Attribute[] attributes = new Attribute[1];
        KeyUsage keyUsage = new KeyUsage(15);
        ExtensionRequest extensionRequest = new ExtensionRequest();
        extensionRequest.addExtension(keyUsage);
        attributes[0] = new Attribute(extensionRequest);
        CSR.setAttributes(attributes);
        byte[] bytes = token.SignSignature(CSR.getCertificateRequestInfo(), PrivateKey2);
        CSR.setSignature(AlgorithmID.sha512WithRSAEncryption, bytes);
        return CSR;
    }

    public byte[] genCSRFile(KeyPair keyPair, X500Name x500Name) throws NoSuchAlgorithmException, IOException, OperatorCreationException {
        String sigAlg = "SHA512withRSA";
        JcaPKCS10CertificationRequestBuilder builder = new JcaPKCS10CertificationRequestBuilder(x500Name, keyPair.getPublic());
        ContentSigner signer = new JcaContentSignerBuilder(sigAlg).build(keyPair.getPrivate());
        PKCS10CertificationRequest csr = builder.build(signer);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write("-----BEGIN CERTIFICATE REQUEST-----\n".getBytes());
        out.write(Base64.getMimeEncoder(64, new byte[]{10}).encode(csr.getEncoded()));
        out.write("\n-----END CERTIFICATE REQUEST-----\n".getBytes());
        return out.toByteArray();
    }

    public static void writeCSRFile(CertificateRequest CSRFile, String Path2) throws IOException {
        byte[] data = CSRFile.toByteArray();
        FileOutputStream fos = new FileOutputStream(Path2);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Base64OutputStream base64os = new Base64OutputStream(bos);
        fos.write("-----BEGIN NEW CERTIFICATE REQUEST-----\r\n".getBytes());
        base64os.write(data);
        base64os.flush();
        String CSRbody = new String(bos.toByteArray());
        fos.write(CSRbody.getBytes());
        fos.write("\r\n-----END NEW CERTIFICATE REQUEST-----".getBytes());
        base64os.close();
        fos.close();
        bos.close();
    }

    public static void writeCSRFile(byte[] data, String Path2) throws IOException {
        FileOutputStream fos = new FileOutputStream(Path2);
        fos.write(data);
        fos.close();
    }

    public static String randomCharacter() {
        Random random = new Random();
        String base = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabsdefghijklmnopqrstuvwxyz";
        String character = Character.toString(base.charAt(random.nextInt(base.length())));
        return character;
    }
}

