/*
 * Decompiled with CFR 0.152.
 */
package keySuite.properties;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;

public class PropertiesManagement {
    Properties prop = new Properties();

    public String getProperties(String key) throws FileNotFoundException, IOException {
        String value = "";
        this.prop.load(new FileInputStream("./res/config/prop.properties"));
        value = this.prop.getProperty(key);
        return value;
    }

    public String getProperties(String propertiesPath, String key) throws FileNotFoundException, IOException {
        String value = "";
        this.prop.load(new FileInputStream(propertiesPath));
        value = this.prop.getProperty(key);
        return value;
    }

    public void setProperties(String key, String value) throws FileNotFoundException, IOException {
        this.prop.load(new FileInputStream("./res/config/prop.properties"));
        FileOutputStream output = new FileOutputStream("./res/config/prop.properties");
        this.prop.setProperty(key, value);
        this.putWithSort(this.prop, output);
    }

    public void setProperties(String propertiesPath, String key, String value) throws FileNotFoundException, IOException {
        this.prop.load(new FileInputStream(propertiesPath));
        FileOutputStream output = new FileOutputStream(propertiesPath);
        this.prop.setProperty(key, value);
        this.putWithSort(this.prop, output);
    }

    public void deleteProperties(String key) throws FileNotFoundException, IOException {
        this.prop.load(new FileInputStream("./res/config/prop.properties"));
        FileOutputStream output = new FileOutputStream("./res/config/prop.properties");
        this.prop.remove(key);
        this.prop.store(output, null);
    }

    public void deleteProperties(String propertiesPath, String key) throws FileNotFoundException, IOException {
        this.prop.load(new FileInputStream(propertiesPath));
        FileOutputStream output = new FileOutputStream(propertiesPath);
        this.prop.remove(key);
        this.prop.store(output, null);
    }

    public void changePropertiesKey(String regex, String replacement) throws IOException {
        this.prop.load(new FileInputStream("./res/config/prop.properties"));
        FileOutputStream output = new FileOutputStream("./res/config/prop.properties");
        for (String key : this.prop.stringPropertyNames()) {
            if (!key.startsWith(regex)) continue;
            String newKey = key.replaceFirst(regex, replacement);
            this.prop.setProperty(newKey, (String)this.prop.remove(key));
        }
        this.prop.store(output, null);
    }

    private void putWithSort(Properties prop, OutputStream output) throws IOException {
        Properties tmp = new Properties(){

            @Override
            public synchronized Enumeration<Object> keys() {
                return Collections.enumeration(new TreeSet<Object>(this.keySet()));
            }
        };
        tmp.putAll((Map<?, ?>)prop);
        tmp.store(output, null);
    }
}

