/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.mime.encoding;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.util.encoders.Base64Encoder;

public class Base64OutputStream
extends FilterOutputStream {
    private static final Base64Encoder ENCODER = new Base64Encoder();
    private static final int INBUF_SIZE = 54;
    private static final int OUTBUF_SIZE = 74;
    private final byte[] inBuf = new byte[54];
    private final byte[] outBuf = new byte[74];
    private int inPos = 0;

    public Base64OutputStream(OutputStream outputStream) {
        super(outputStream);
        this.outBuf[72] = 13;
        this.outBuf[73] = 10;
    }

    public void write(int n2) throws IOException {
        this.inBuf[this.inPos++] = (byte)n2;
        if (this.inPos == 54) {
            this.encodeBlock(this.inBuf, 0);
            this.inPos = 0;
        }
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5 = 54 - this.inPos;
        if (n3 < n5) {
            System.arraycopy(byArray, n2, this.inBuf, this.inPos, n3);
            this.inPos += n3;
            return;
        }
        int n6 = 0;
        if (this.inPos > 0) {
            System.arraycopy(byArray, n2, this.inBuf, this.inPos, n5);
            n6 += n5;
            this.encodeBlock(this.inBuf, 0);
        }
        while ((n4 = n3 - n6) >= 54) {
            this.encodeBlock(byArray, n2 + n6);
            n6 += 54;
        }
        System.arraycopy(byArray, n2 + n6, this.inBuf, 0, n4);
        this.inPos = n4;
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void close() throws IOException {
        if (this.inPos > 0) {
            int n2 = ENCODER.encode(this.inBuf, 0, this.inPos, this.outBuf, 0);
            this.inPos = 0;
            this.outBuf[n2++] = 13;
            this.outBuf[n2++] = 10;
            this.out.write(this.outBuf, 0, n2);
        }
        this.out.close();
    }

    private void encodeBlock(byte[] byArray, int n2) throws IOException {
        ENCODER.encode(byArray, n2, 54, this.outBuf, 0);
        this.out.write(this.outBuf, 0, 74);
    }
}

