/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.oer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1ApplicationSpecific;
import org.bouncycastle.asn1.ASN1Boolean;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Enumerated;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.ASN1UTF8String;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.oer.BitBuilder;
import org.bouncycastle.oer.OERDefinition;
import org.bouncycastle.oer.OEROptional;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

public class OEROutputStream {
    private final OutputStream out;
    private static final int[] bits = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
    protected PrintWriter debugOutput = null;

    public static OEROutputStream create(OutputStream outputStream) {
        return new OEROutputStream(outputStream);
    }

    OEROutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void write(ASN1Encodable aSN1Encodable, OERDefinition.Element element) throws IOException {
        if (aSN1Encodable == OEROptional.ABSENT) {
            return;
        }
        if (aSN1Encodable instanceof OEROptional) {
            this.write(((OEROptional)aSN1Encodable).get(), element);
            return;
        }
        aSN1Encodable = aSN1Encodable.toASN1Primitive();
        switch (element.baseType) {
            case SEQ: {
                Object object;
                Object object2;
                int n2;
                ASN1Sequence aSN1Sequence = ASN1Sequence.getInstance(aSN1Encodable);
                int n3 = 7;
                int n4 = 0;
                if (element.extensionsInDefinition) {
                    if (element.hasPopulatedExtension()) {
                        n4 |= bits[n3];
                    }
                    --n3;
                }
                for (n2 = 0; n2 < element.children.size(); ++n2) {
                    object2 = element.children.get(n2);
                    if (n3 < 0) {
                        this.out.write(n4);
                        n3 = 7;
                        n4 = 0;
                    }
                    object = aSN1Sequence.getObjectAt(n2);
                    if (((OERDefinition.Element)object2).explicit && object instanceof OEROptional) {
                        throw new IllegalStateException("absent sequence element that is required by oer definition");
                    }
                    if (((OERDefinition.Element)object2).explicit) continue;
                    ASN1Encodable aSN1Encodable2 = aSN1Sequence.getObjectAt(n2);
                    if (((OERDefinition.Element)object2).getDefaultValue() != null) {
                        if (aSN1Encodable2 instanceof OEROptional) {
                            if (((OEROptional)aSN1Encodable2).isDefined() && !((OEROptional)aSN1Encodable2).get().equals(((OERDefinition.Element)object2).defaultValue)) {
                                n4 |= bits[n3];
                            }
                        } else if (!((OERDefinition.Element)object2).getDefaultValue().equals(aSN1Encodable2)) {
                            n4 |= bits[n3];
                        }
                    } else if (object != OEROptional.ABSENT) {
                        n4 |= bits[n3];
                    }
                    --n3;
                }
                if (n3 != 7) {
                    this.out.write(n4);
                }
                for (n2 = 0; n2 < element.children.size(); ++n2) {
                    object2 = aSN1Sequence.getObjectAt(n2);
                    object = element.children.get(n2);
                    if (((OERDefinition.Element)object).getDefaultValue() != null && ((OERDefinition.Element)object).getDefaultValue().equals(object2)) continue;
                    this.write((ASN1Encodable)object2, (OERDefinition.Element)object);
                }
                this.out.flush();
                this.debugPrint(element.appendLabel(""));
                break;
            }
            case SEQ_OF: {
                Enumeration enumeration;
                if (aSN1Encodable instanceof ASN1Set) {
                    enumeration = ((ASN1Set)aSN1Encodable).getObjects();
                    this.encodeQuantity(((ASN1Set)aSN1Encodable).size());
                } else if (aSN1Encodable instanceof ASN1Sequence) {
                    enumeration = ((ASN1Sequence)aSN1Encodable).getObjects();
                    this.encodeQuantity(((ASN1Sequence)aSN1Encodable).size());
                } else {
                    throw new IllegalStateException("encodable at for SEQ_OF is not a container");
                }
                while (enumeration.hasMoreElements()) {
                    Object e2 = enumeration.nextElement();
                    this.write((ASN1Encodable)e2, element.getFirstChid());
                }
                this.out.flush();
                this.debugPrint(element.appendLabel(""));
                break;
            }
            case CHOICE: {
                int n5;
                ASN1Primitive aSN1Primitive = aSN1Encodable.toASN1Primitive();
                BitBuilder bitBuilder = new BitBuilder();
                if (aSN1Primitive instanceof ASN1ApplicationSpecific) {
                    n5 = ((ASN1ApplicationSpecific)aSN1Primitive).getApplicationTag();
                    bitBuilder.writeBit(0).writeBit(1);
                    aSN1Primitive = ((ASN1ApplicationSpecific)aSN1Primitive).getEnclosedObject();
                } else if (aSN1Primitive instanceof ASN1TaggedObject) {
                    ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)aSN1Primitive;
                    int n6 = aSN1TaggedObject.getTagClass();
                    bitBuilder.writeBit(n6 & 0x80).writeBit(n6 & 0x40);
                    n5 = aSN1TaggedObject.getTagNo();
                    aSN1Primitive = aSN1TaggedObject.getBaseObject().toASN1Primitive();
                } else {
                    throw new IllegalStateException("only support tagged objects");
                }
                if (n5 <= 63) {
                    bitBuilder.writeBits(n5, 6);
                } else {
                    bitBuilder.writeBits(255L, 6);
                    bitBuilder.write7BitBytes(n5);
                }
                if (this.debugOutput != null) {
                    if (aSN1Primitive instanceof ASN1ApplicationSpecific) {
                        this.debugPrint(element.appendLabel("AS"));
                    } else if (aSN1Primitive instanceof ASN1TaggedObject) {
                        this.debugPrint(element.appendLabel("CS"));
                    }
                }
                bitBuilder.writeAndClear(this.out);
                this.write(aSN1Primitive, element.children.get(n5));
                this.out.flush();
                break;
            }
            case ENUM: {
                BigInteger bigInteger = aSN1Encodable instanceof ASN1Integer ? ASN1Integer.getInstance(aSN1Encodable).getValue() : ASN1Enumerated.getInstance(aSN1Encodable).getValue();
                for (OERDefinition.Element element2 : element.children) {
                    if (!element2.enumValue.equals(bigInteger)) continue;
                    if (bigInteger.compareTo(BigInteger.valueOf(127L)) > 0) {
                        byte[] byArray = bigInteger.toByteArray();
                        int n7 = 0x80 | byArray.length & 0xFF;
                        this.out.write(n7);
                        this.out.write(byArray);
                    } else {
                        this.out.write(bigInteger.intValue() & 0x7F);
                    }
                    this.out.flush();
                    this.debugPrint(element.appendLabel(element.rangeExpression()));
                    return;
                }
                throw new IllegalArgumentException("enum value " + bigInteger + " " + Hex.toHexString(bigInteger.toByteArray()) + " no in defined child list");
            }
            case INT: {
                ASN1Integer aSN1Integer = ASN1Integer.getInstance(aSN1Encodable);
                int n8 = element.intBytesForRange();
                if (n8 > 0) {
                    byte[] byArray = BigIntegers.asUnsignedByteArray(n8, aSN1Integer.getValue());
                    switch (n8) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 8: {
                            this.out.write(byArray);
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unknown uint length " + n8);
                        }
                    }
                } else if (n8 < 0) {
                    byte[] byArray;
                    BigInteger bigInteger = aSN1Integer.getValue();
                    switch (n8) {
                        case -1: {
                            byArray = new byte[]{BigIntegers.byteValueExact(bigInteger)};
                            break;
                        }
                        case -2: {
                            byArray = Pack.shortToBigEndian(BigIntegers.shortValueExact(bigInteger));
                            break;
                        }
                        case -4: {
                            byArray = Pack.intToBigEndian(BigIntegers.intValueExact(bigInteger));
                            break;
                        }
                        case -8: {
                            byArray = Pack.longToBigEndian(BigIntegers.longValueExact(bigInteger));
                            break;
                        }
                        default: {
                            throw new IllegalStateException("unknown twos compliment length");
                        }
                    }
                    this.out.write(byArray);
                } else {
                    byte[] byArray = element.isLowerRangeZero() ? BigIntegers.asUnsignedByteArray(aSN1Integer.getValue()) : aSN1Integer.getValue().toByteArray();
                    this.encodeLength(byArray.length);
                    this.out.write(byArray);
                }
                this.debugPrint(element.appendLabel(element.rangeExpression()));
                this.out.flush();
                break;
            }
            case OCTET_STRING: {
                ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(aSN1Encodable);
                byte[] byArray = aSN1OctetString.getOctets();
                if (element.isFixedLength()) {
                    this.out.write(byArray);
                } else {
                    this.encodeLength(byArray.length);
                    this.out.write(byArray);
                }
                this.debugPrint(element.appendLabel(element.rangeExpression()));
                this.out.flush();
                break;
            }
            case UTF8_STRING: {
                ASN1UTF8String aSN1UTF8String = ASN1UTF8String.getInstance(aSN1Encodable);
                byte[] byArray = Strings.toUTF8ByteArray(aSN1UTF8String.getString());
                this.encodeLength(byArray.length);
                this.out.write(byArray);
                this.debugPrint(element.appendLabel(""));
                this.out.flush();
                break;
            }
            case BIT_STRING: {
                DERBitString dERBitString = DERBitString.getInstance(aSN1Encodable);
                byte[] byArray = dERBitString.getBytes();
                if (element.isFixedLength()) {
                    this.out.write(byArray);
                    this.debugPrint(element.appendLabel(element.rangeExpression()));
                } else {
                    int n9 = dERBitString.getPadBits();
                    this.encodeLength(byArray.length + 1);
                    this.out.write(n9);
                    this.out.write(byArray);
                    this.debugPrint(element.appendLabel(element.rangeExpression()));
                }
                this.out.flush();
                break;
            }
            case NULL: {
                break;
            }
            case EXTENSION: {
                ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(aSN1Encodable);
                byte[] byArray = aSN1OctetString.getOctets();
                if (element.isFixedLength()) {
                    this.out.write(byArray);
                } else {
                    this.encodeLength(byArray.length);
                    this.out.write(byArray);
                }
                this.debugPrint(element.appendLabel(element.rangeExpression()));
                this.out.flush();
                break;
            }
            case ENUM_ITEM: {
                break;
            }
            case BOOLEAN: {
                this.debugPrint(element.label);
                ASN1Boolean aSN1Boolean = ASN1Boolean.getInstance(aSN1Encodable);
                if (aSN1Boolean.isTrue()) {
                    this.out.write(255);
                } else {
                    this.out.write(0);
                }
                this.out.flush();
            }
        }
    }

    protected void debugPrint(String string) {
        if (this.debugOutput != null) {
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            int n2 = -1;
            for (int i2 = 0; i2 != stackTraceElementArray.length; ++i2) {
                StackTraceElement stackTraceElement = stackTraceElementArray[i2];
                if (stackTraceElement.getMethodName().equals("debugPrint")) {
                    n2 = 0;
                    continue;
                }
                if (!stackTraceElement.getClassName().contains("OERInput")) continue;
                ++n2;
            }
            while (n2 > 0) {
                this.debugOutput.append("    ");
                --n2;
            }
            this.debugOutput.append(string).append("\n");
            this.debugOutput.flush();
        }
    }

    private void encodeLength(long l2) throws IOException {
        if (l2 <= 127L) {
            this.out.write((int)l2);
        } else {
            byte[] byArray = BigIntegers.asUnsignedByteArray(BigInteger.valueOf(l2));
            this.out.write(byArray.length | 0x80);
            this.out.write(byArray);
        }
    }

    private void encodeQuantity(long l2) throws IOException {
        byte[] byArray = BigIntegers.asUnsignedByteArray(BigInteger.valueOf(l2));
        this.out.write(byArray.length);
        this.out.write(byArray);
    }

    public static int byteLength(long l2) {
        int n2;
        long l3 = -72057594037927936L;
        for (n2 = 8; n2 > 0 && (l2 & l3) == 0L; --n2) {
            l2 <<= 8;
        }
        return n2;
    }
}

