/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.operator;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.util.Arrays;

public class MacCaptureStream
extends OutputStream {
    private final OutputStream cOut;
    private final byte[] mac;
    int macIndex = 0;

    public MacCaptureStream(OutputStream outputStream, int n2) {
        this.cOut = outputStream;
        this.mac = new byte[n2];
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (n3 >= this.mac.length) {
            this.cOut.write(this.mac, 0, this.macIndex);
            this.macIndex = this.mac.length;
            System.arraycopy(byArray, n2 + n3 - this.mac.length, this.mac, 0, this.mac.length);
            this.cOut.write(byArray, n2, n3 - this.mac.length);
        } else {
            for (int i2 = 0; i2 != n3; ++i2) {
                this.write(byArray[n2 + i2]);
            }
        }
    }

    public void write(int n2) throws IOException {
        if (this.macIndex == this.mac.length) {
            byte by = this.mac[0];
            System.arraycopy(this.mac, 1, this.mac, 0, this.mac.length - 1);
            this.mac[this.mac.length - 1] = (byte)n2;
            this.cOut.write(by);
        } else {
            this.mac[this.macIndex++] = (byte)n2;
        }
    }

    public byte[] getMac() {
        return Arrays.clone(this.mac);
    }
}

